function estimateAlignment
% Estimate between channel bias from superSegger data. Set path to segger folder.
% This assumes random orientation of cells and it adjusts the average spots
% distance to cell center to be zero on both xy-axis.

% save 'out' variable (format by superSegger)
% [error, diffphase, net_row_shift, net_col_shift]
%           error : Translation invariant normalized RMS error between f and g
%           diffphase : Global phase difference between the two images (should be
%           zero if images are non-negative).
% values (3) and (4) are used in image shifting, (1) and (2) are zeros


%% Collect data from all XYs into a spots array

locus1 = [];
locus2 = [];
locus3 = [];
allfolders = dir('xy*');
for jj = 1:length(allfolders)   % XY
    folder = allfolders(jj).name;
    clist = load([folder '\' 'clist.mat']);
    
    % filtering parameters for cells
    minArea = 60;       % to avoid not cells
    maxArea = 220;      % to avoid clumps
    minwidth = 4.5;     % to avoid not cells
    maxwidth = 7;       % to avoid clumps
    
    mask1 = clist.data(:,14) >= minArea & clist.data(:,14) <= maxArea;  % cell area min/max
    mask2 = clist.data(:,12) >= minwidth;	% min width
    mask3 = clist.data(:,12) <= maxwidth;	% max width
    
    mask = mask1 & mask2 & mask3;
    indeces = find(mask == 1);
    
    % find cell.mat files and order by number
    allcells = what([folder '\' 'cell' '\']);
    names = cell(1,length(allcells.mat));
    for ll = 1:length(allcells.mat)
         splitted = strsplit(allcells.mat{ll},'ll');
         names{ll} = splitted{2};
    end
    [~, I] = sort(names); 
    names = allcells.mat(I);

    for ii = 1:length(indeces)  % cells
        cellname = ['' names{indeces(ii)}];
        currentCell = load([folder '\' 'cell' '\' cellname]);
        for kk = 1:length(currentCell.CellA)    % times
            % locus 1
            r = [currentCell.CellA{kk}.locus1(:).r]; % [x y x y...]
            for pp = 1:(length(r)/2)
                locus1 = [locus1 (r((2*pp-1):2*pp)-currentCell.CellA{kk}.coord.rcm)'];
            end

            % locus 2
            if isfield(currentCell.CellA{kk},'locus3')
                r = [currentCell.CellA{kk}.locus2(:).r]; % [x y x y...]
                for pp = 1:(length(r)/2)
                    locus2 = [locus2 (r((2*pp-1):2*pp)-currentCell.CellA{kk}.coord.rcm)'];
                end
            else
                locus2 = zeros(2,100);
            end
            
            % locus 3
            if isfield(currentCell.CellA{kk},'locus3')
                r = [currentCell.CellA{kk}.locus3(:).r]; % [x y x y...]
                for pp = 1:(length(r)/2)
                    locus3 = [locus3 (r((2*pp-1):2*pp)-currentCell.CellA{kk}.coord.rcm)'];
                end
            else
                locus3 = zeros(2,100);
            end
        end
    end
end

 % remove outliers and calculate mean
percent = 25;   % percentage of highest and lowest values removed
locus1_meanX = trimmean(locus1(1,:),percent);
locus1_meanY = trimmean(locus1(2,:),percent);

locus2_meanX = trimmean(locus2(1,:),percent);
locus2_meanY = trimmean(locus2(2,:),percent);
locus3_meanX = trimmean(locus3(1,:),percent);
locus3_meanY = trimmean(locus3(2,:),percent);

% save values to out variable
out = cell(1,3);
out{1} = [0 0 -locus1_meanY -locus1_meanX];
out{2} = [0 0 -locus2_meanY -locus2_meanX];
out{3} = [0 0 -locus3_meanY -locus3_meanX];

% saves spots data structure
save('imAlign.mat','out')

end

